<?php
// Database connection details
require_once '../config.php';

// Create a PDO instance
try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}

// Function to generate a random password
function generateRandomPassword($length = 8) {
    $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $password = '';
    for ($i = 0; $i < $length; $i++) {
        $index = rand(0, strlen($characters) - 1);
        $password .= $characters[$index];
    }
    return $password;
}

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve form data
    $username = $_POST['username'];
    $password = $_POST['password'];
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT); // Hash the password
    $user_type = $_POST['user_type'];
    $zone = $_POST['zone'];
    $country = $_POST['country'];
    $state = $_POST['state'];
    $church = $_POST['church'];
    $cell = $_POST['cell'];
    $comment = $_POST['comment'];
    $name = $_POST['name'];
    $phone = $_POST['phone'];
    $cell_id = $_POST['cell_id'];
    $church_id = $_POST['church_id'];
    $social_platform = $_POST['social_platform'];
    $social_id = $_POST['social_id'];

    // Prepare and execute the query
    $stmt = $pdo->prepare("INSERT INTO users (username, password, user_type, zone, country, state, church, cell, comment, name, phone, cell_id, church_id, social_platform, social_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$username, $hashedPassword, $user_type, $zone, $country, $state, $church, $cell, $comment, $name, $phone, $cell_id, $church_id, $social_platform, $social_id]);

    //display password
    include('../headerspecial.php');

    // Display the account details to the user
    echo "<h1>Account Created</h1>";
    echo "<p>Zone: $zone</p>";
    echo "<p>Email: $username</p>";
    echo "<p>Username: $username</p>";
    echo "<p>Default Password: $password</p><p>&nbsp;</p>";
    echo "<a href='create_user.php'>Create another Zonal User</a> | <a href='usermanagement.php'>Return to Zonal User Directory</a> <p>&nbsp;</p>";
    // Redirect to success page

    //header("Location: member_list.php");
    //exit();
}
?>
<?php include('../headerspecial.php'); ?>
<!DOCTYPE html>
<html>
<head>
    <title>Create User Account</title>
</head>
<body>
    <h1>Create User Account</h1>
    <form method="POST" action="">

    <label for="name">Name:</label>
        <input type="text" name="name"><p>

        <label for="phone">Phone:</label>
        <input type="text" name="phone"><p>
<hr>
        <label for="username">Username:</label>
        <input type="text" name="username" required><p>

        <label for="password">Password:</label>
        <input type="password" name="password" value="<?php echo generateRandomPassword(); ?>" required><p>
<hr>
        <label for="user_type">User Type:</label>
        <select name="user_type">
            <option value="member">Zonal Rep</option>
            <option value="admin">Admin</option>
        </select><p>

        <label for="zone">Zone:</label>
        <input type="text" name="zone"><p>

        <label for="country">Country:</label>
       	<select id="country" name="country"  class="form-input"></select>

<script>

  const allCountries = [
    "Afghanistan", "Albania", "Algeria", "Andorra", "Angola", "Antigua and Barbuda", "Argentina", "Armenia",
    "Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium",
    "Belize", "Benin", "Bhutan", "Bolivia", "Bosnia and Herzegovina", "Botswana", "Brazil", "Brunei", "Bulgaria",
    "Burkina Faso", "Burundi", "Cabo Verde", "Cambodia", "Cameroon", "Canada", "Central African Republic", "Chad",
    "Chile", "China", "Colombia", "Comoros", "Congo", "Costa Rica", "Cote d'Ivoire", "Croatia", "Cuba", "Cyprus",
    "Czechia", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "Ecuador", "Egypt", "El Salvador",
    "Equatorial Guinea", "Eritrea", "Estonia", "Eswatini", "Ethiopia", "Fiji", "Finland", "France", "Gabon",
    "Gambia", "Georgia", "Germany", "Ghana", "Greece", "Grenada", "Guatemala", "Guinea", "Guinea-Bissau", "Guyana",
    "Haiti", "Honduras", "Hungary", "Iceland", "India", "Indonesia", "Iran", "Iraq", "Ireland", "Israel", "Italy",
    "Jamaica", "Japan", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Korea, North", "Korea, South", "Kosovo",
    "Kuwait", "Kyrgyzstan", "Laos", "Latvia", "Lebanon", "Lesotho", "Liberia", "Libya", "Liechtenstein", "Lithuania",
    "Luxembourg", "Madagascar", "Malawi", "Malaysia", "Maldives", "Mali", "Malta", "Marshall Islands", "Mauritania",
    "Mauritius", "Mexico", "Micronesia", "Moldova", "Monaco", "Mongolia", "Montenegro", "Morocco", "Mozambique",
    "Myanmar", "Namibia", "Nauru", "Nepal", "Netherlands", "New Zealand", "Nicaragua", "Niger", "Nigeria",
    "North Macedonia", "Norway", "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea", "Paraguay", "Peru",
    "Philippines", "Poland", "Portugal", "Qatar", "Romania", "Russia", "Rwanda", "Saint Kitts and Nevis",
    "Saint Lucia", "Saint Vincent and the Grenadines", "Samoa", "San Marino", "Sao Tome and Principe", "Saudi Arabia",
    "Senegal", "Serbia", "Seychelles", "Sierra Leone", "Singapore", "Slovakia", "Slovenia", "Solomon Islands",
    "Somalia", "South Africa", "South Sudan", "Spain", "Sri Lanka", "Sudan", "Suriname", "Sweden", "Switzerland",
    "Syria", "Taiwan", "Tajikistan", "Tanzania", "Thailand", "Timor-Leste", "Togo", "Tonga", "Trinidad and Tobago",
    "Tunisia", "Turkey", "Turkmenistan", "Tuvalu", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom",
    "United States", "Uruguay", "Uzbekistan", "Vanuatu", "Vatican City", "Venezuela", "Vietnam", "Yemen", "Zambia", "Zimbabwe"
  ];

  const selectElement = document.getElementById("country");

  // Add the full list
  const allCountriesOptgroup = document.createElement("optgroup");
  allCountriesOptgroup.label = "World";

  for (const country of allCountries) {
    const option = document.createElement("option");
    option.value = country.toLowerCase();
    option.text = country;
    allCountriesOptgroup.appendChild(option);
  }

  selectElement.appendChild(allCountriesOptgroup);
</script>
<p>

        <input type="hidden" name="state" value = "NULL">
        <input type="hidden" name="church" value = "NULL">
        <input type="hidden" name="cell" value = "NULL">
        <input type="hidden" name="cell_id" value = "NULL">
        <input type="hidden" name="church_id" value = "NULL">
        <label for="social_platform">Social Platform:</label>
        <input type="text" name="social_platform" value = "Kingschat" READONLY><p>
        <label for="social_id">Kingschat ID:</label>
        <input type="text" name="social_id"><p>

        <label for="comment">Comment:</label>
        <input type="textarea" name="comment"><p>
<hr>
        <input type="submit" value="Create Account">
    </form>
    </body>
</html>
