<?php
// Include necessary files and start session
require_once 'config.php';
session_start();

// Check if the user is logged in as a system admin
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = sanitizeInput($_POST['user_id']);
    $payment_amount = sanitizeInput($_POST['payment_amount']);
    $quota_value = sanitizeInput($_POST['quota_value']);
    $comment = sanitizeInput($_POST['comment']);
    $zone = sanitizeInput($_POST['zone']);

    // Validate the input values
    if (validateInput($user_id, $payment_amount, $quota_value, $comment, $zone)) {
        // Update the quota table for the user
        updateQuota($user_id, $quota_value, $comment, $zone);
    } else {
        echo "Invalid input.";
    }
}

// Function to sanitize user input
function sanitizeInput($input) {
    $sanitized = trim($input);
    $sanitized = htmlspecialchars($sanitized);
    // You can add more sanitization techniques as per your requirements
    return $sanitized;
}

// Function to validate input values
function validateInput($user_id, $payment_amount, $quota_value, $comment, $zone) {
    // Perform necessary validation checks
    if (empty($user_id) || !is_numeric($user_id)) {
        return false;
    }
    if (empty($payment_amount) || !is_numeric($payment_amount)) {
        return false;
    }
    if (empty($quota_value) || !is_numeric($quota_value)) {
        return false;
    }
    // You can add more validation rules as per your requirements
    return true;
}

// Function to update the quota table
function updateQuota($user_id, $quota_value, $comment, $zone) {
    // Add your logic to update the quota table in the database
    // Example:
    $query = "UPDATE Quotas SET quota_amount = $quota_value, comment = '$comment' WHERE user_id = $user_id";
    $result = mysqli_query($connection, $query);
    if ($result) {
        // Success message
        echo "Quota updated successfully.";
    } else {
        // Error message
        echo "Error updating quota: " . mysqli_error($connection);
    }
}

// Render the manually confirmed payment page
?>
<!DOCTYPE html>
<html>
<head>
    <title>Manually Confirmed Payment</title>
    <!-- Add your CSS and JS files here -->
</head>
<body>
    <h1>Manually Confirmed Payment</h1>
    <form method="POST" action="">
        <label for="user_id">User ID:</label>
        <input type="text" name="user_id" id="user_id" required>

        <label for="payment_amount">Payment Amount:</label>
        <input type="text" name="payment_amount" id="payment_amount" required>

        <label for="quota_value">Quota Value:</label>
        <input type="text" name="quota_value" id="quota_value" required>

        <label for="comment">Comment:</label>
        <input type="text" name="comment" id="comment">

        <label for="zone">Zone:</label>
        <input type="text" name="zone" id="zone">

        <button type="submit">Confirm Payment</button>
    </form>
    <!-- Add other content and functionalities as needed -->
</body>
</html>
