<?php
// Include necessary files and start session
require_once 'config.php';
session_start();

// Check if the user is logged in as a system admin
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

// Function to retrieve the list of nominees
function getNominees() {
    // Add your logic to fetch the list of nominees from the database
    // Example:
    // $query = "SELECT * FROM nominees";
    // $result = mysqli_query($connection, $query);
    // $nominees = mysqli_fetch_all($result, MYSQLI_ASSOC);
    // return $nominees;

    // Replace the return statement with your own logic
    return [
        ['id' => 1, 'name' => 'John Doe', 'email' => 'john@example.com', 'phone' => '1234567890', 'status' => 'Pending'],
        ['id' => 2, 'name' => 'Jane Smith', 'email' => 'jane@example.com', 'phone' => '9876543210', 'status' => 'Approved'],
        ['id' => 3, 'name' => 'Mike Johnson', 'email' => 'mike@example.com', 'phone' => '5555555555', 'status' => 'Pending'],
        ['id' => 4, 'name' => 'Sarah Williams', 'email' => 'sarah@example.com', 'phone' => '9999999999', 'status' => 'Approved'],
    ];
}

// Render the nominee management page
?>
<!DOCTYPE html>
<html>
<head>
    <title>Nominee Management</title>
    <!-- Add your CSS and JS files here -->
</head>
<body>
    <h1>Nominee Management</h1>
    <table>
        <thead>
            <tr>
                <th>Nominee ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Status</th>
                <th>Edit</th>
                <th>Delete</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach (getNominees() as $nominee) : ?>
            <tr>
                <td><?php echo $nominee['id']; ?></td>
                <td><?php echo $nominee['name']; ?></td>
                <td><?php echo $nominee['email']; ?></td>
                <td><?php echo $nominee['phone']; ?></td>
                <td><?php echo $nominee['status']; ?></td>
                <td><a href="editnominee.php?id=<?php echo $nominee['id']; ?>">Edit</a></td>
                <td><a href="deletenominee.php?id=<?php echo $nominee['id']; ?>">Delete</a></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <!-- Add other content and functionalities as needed -->
</body>
</html>
