<?php
// Include necessary files and start session
require_once 'config.php';
session_start();

// Check if the user is logged in as a system admin
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

// Function to retrieve the list of payments
function getPayments() {
    // Add your logic to fetch the list of payments from the database
    // Example:
    // $query = "SELECT * FROM payments";
    // $result = mysqli_query($connection, $query);
    // $payments = mysqli_fetch_all($result, MYSQLI_ASSOC);
    // return $payments;

    // Replace the return statement with your own logic
    return [
        ['payment_id' => 1, 'user_id' => 1, 'payment_amount' => 100, 'payment_method' => 'Credit Card', 'payment_status' => 'Completed'],
        ['payment_id' => 2, 'user_id' => 2, 'payment_amount' => 50, 'payment_method' => 'PayPal', 'payment_status' => 'Pending'],
        ['payment_id' => 3, 'user_id' => 3, 'payment_amount' => 75, 'payment_method' => 'Bank Transfer', 'payment_status' => 'Completed'],
        ['payment_id' => 4, 'user_id' => 4, 'payment_amount' => 200, 'payment_method' => 'Cash', 'payment_status' => 'Completed'],
    ];
}

// Render the payment management page
?>
<!DOCTYPE html>
<html>
<head>
    <title>Payment Management</title>
    <!-- Add your CSS and JS files here -->
</head>
<body>
    <h1>Payment Management</h1>
    <table>
        <thead>
            <tr>
                <th>Payment ID</th>
                <th>User ID</th>
                <th>Payment Amount</th>
                <th>Payment Method</th>
                <th>Payment Status</th>
                <th>Edit</th>
                <th>Delete</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach (getPayments() as $payment) : ?>
            <tr>
                <td><?php echo $payment['payment_id']; ?></td>
                <td><?php echo $payment['user_id']; ?></td>
                <td><?php echo $payment['payment_amount']; ?></td>
                <td><?php echo $payment['payment_method']; ?></td>
                <td><?php echo $payment['payment_status']; ?></td>
                <td><a href="editpayment.php?id=<?php echo $payment['payment_id']; ?>">Edit</a></td>
                <td><a href="deletepayment.php?id=<?php echo $payment['payment_id']; ?>">Delete</a></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <!-- Add other content and functionalities as needed -->
</body>
</html>
