<?php
// Include necessary files and start session
require_once '../config.php';
session_start();

// Check if the user is logged in as a system admin
$connection = mysqli_connect($db_host, $db_user, $db_password, $db_name);

if (!isset($_SESSION['userType']) || $_SESSION['userType'] !== 'admin') {
    header('Location: ../indexX.php');
    exit;
}

// Function to retrieve the list of users
function getUsers() {
    // Add your logic to fetch the list of users from the database
    // Add the global keyword to access the $connection variable within the function
    global $connection;

    $query = "SELECT * FROM users where user_type = 'member'";
    $result = mysqli_query($connection, $query);
    $users = mysqli_fetch_all($result, MYSQLI_ASSOC);
    return $users;

    // Replace the return statement with your own logic
    /*return [
        ['id' => 1, 'username' => 'john', 'user_type' => 'Admin', 'email' => 'john@example.com', 'status' => 'Active', 'zone' => 'Abuja Zone 1'],
        ['id' => 2, 'username' => 'mary', 'user_type' => 'User', 'email' => 'mary@example.com', 'status' => 'Active', 'zone' => 'South East Asia'],
        ['id' => 3, 'username' => 'james', 'user_type' => 'User', 'email' => 'james@example.com', 'status' => 'Inactive', 'zone' => 'Abuja Zone 2'],
        ['id' => 4, 'username' => 'sarah', 'user_type' => 'User', 'email' => 'sarah@example.com', 'status' => 'Active', 'zone' => 'Lagos Zone 1'],
    ];*/
}

// Render the user management page
include('../headerspecial.php');
?>
<!DOCTYPE html>
<html>
<head>
    <title>User Management</title>
    <!-- Add your CSS and JS files here -->
</head>
<body>
    <h1>User Management</h1>

    <p>
      <a href="create_user.php">Add Zonal User</a><p>
    <table border="1">
        <thead>
            <tr>
                <th>User ID</th>
                <th>Zone</th>
                <th>Username</th>
                <th>User Type</th>
            <!--    <th>Email</th>-->
                <th>Credits</th>
                <th>Payment</th>
                <th>Edit</th>
                <th>Delete</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach (getUsers() as $user) : ?>
            <tr>
                <td><?php echo $user['id']; ?></td>
                <td><?php echo $user['zone']; ?></td>
                <td><?php echo $user['username']; ?></td>
                <td><?php if ($user['user_type'] == 'member') {echo 'Zonal Account';} ?></td>
            <!--    <td><?php echo $user['email']; ?></td>-->
                <td><?php echo $user['credits']; ?></td>
                <td><a href="confirm_payment.php?id=<?php echo $user['id']; ?>&zone=<?php echo $user['zone']; ?>">Payment</a></td>
                <td><a href="edituser.php?id=<?php echo $user['id']; ?>">Edit</a></td>
                <td><a href="deleteuser.php?id=<?php echo $user['id']; ?>">Delete</a></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <!-- Add other content and functionalities as needed -->
</body>
</html>
