<?php
// Include necessary files and start session
require_once 'config.php';
session_start();

// Check if the user is logged in as a system admin
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

// Retrieve and display the list of church zones
$zones = getZones(); // Function to retrieve the list of zones

// Render the zone management page
?>
<!DOCTYPE html>
<html>
<head>
    <title>Zone Management</title>
    <!-- Add your CSS and JS files here -->
</head>
<body>
    <h1>Zone Management</h1>
    <table>
        <thead>
            <tr>
                <th>Zone ID</th>
                <th>Zone Name</th>
                <th>Edit</th>
                <th>Delete</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($zones as $zone) : ?>
            <tr>
                <td><?php echo $zone['zone_id']; ?></td>
                <td><?php echo $zone['zone_name']; ?></td>
                <td><a href="editzone.php?id=<?php echo $zone['zone_id']; ?>">Edit</a></td>
                <td><a href="deletezone.php?id=<?php echo $zone['zone_id']; ?>">Delete</a></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <!-- Add other content and functionalities as needed -->
</body>
</html>
