<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registration Form</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <div class="container">
        
        <div id="registration-status" class="alert" style="display: none;"></div>
<!--<div id="success-message" style="display: none;">
<p>Registration successful!</p>
</div>-->
<!--
<div id="success-message" style="display: none; background-color: #dff0d8; padding: 10px; border-radius: 10px; border: 1px solid #3e8e41; color: #3e8e41;">
    <p>Registration successful!</p>
</div>-->

<div id="success-message" style="display: none; background-color: #dff0d8; padding: 10px; border-radius: 10px; border: 1px solid #3e8e41; color: #3e8e41; text-align: center; margin: 0 auto; width: 50%;">
  <p style="text-align: center;">Registration successful!</p>
</div>
       <!-- <h1>Registration Form</h1>-->
        <form id="registration-form">
        <!-- Rest of the form fields -->
        <div class="form-group">
            <label for="title">Title</label>
            <select class="form-control" id="title" name="title" required>
                <option value="">Select a title</option>
                <option value="Brother">Brother</option>
                <option value="Sister">Sister</option>
                <option value="Deacon">Deacon</option>
                <option value="Deaconess">Deaconess</option>
                <option value="Pastor">Pastor</option>
                <option value="Evangelist">Evangelist</option>
                <option value="Reverend">Reverend</option>
            </select>
        </div>
        <div class="form-group">
            <label for="first_name">First Name</label>
            <input type="text" class="form-control" id="first_name" name="first_name" required>
        </div>
        <div class="form-group">
            <label for="last_name">Last Name</label>
            <input type="text" class="form-control" id="last_name" name="last_name" required>
        </div>
        <div class="form-group">
            <label for="zone">Zone</label>
            <input type="text" class="form-control" id="zone" name="zone" required>
        </div>
        <div class="form-group">
            <label for="church">Church</label>
            <input type="text" class="form-control" id="church" name="church" required>
        </div>
        <div class="form-group">
            <label for="kingschat_number">Kingschat Number</label>
            <input type="text" class="form-control" id="kingschat_number" name="kingschat_number" required>
        </div>
        <div class="form-group">
            <label for="email">Email</label>
            <input type="email" class="form-control" id="email" name="email" required>
        </div>
        <div class="form-group">
            <label for="phone_number">Phone Number</label>
            <input type="tel" class="form-control" id="phone_number" name="phone_number" required>
        </div>
        <div class="form-group">
            <label for="year_joined_church">Year Joined Christ Embassy</label>
            <input type="year" class="form-control" id="year_joined_church" name="year_joined_church"  min="1970" max="2030"  required>
        </div>
        <div class="form-group">
            <label for="water_baptized">Are you water baptized?</label>
            <select class="form-control" id="water_baptized" name="water_baptized" required>
                <option value="">Select an option</option>
                <option value="yes">Yes</option>
                <option value="no">No</option>
            </select>
        </div>
        <div class="form-group">
            <label for="year_graduated_foundation">Year Graduated from Foundation School</label>
            <input type="number" class="form-control" id="year_graduated_foundation" name="year_graduated_foundation"  min="1970" max="2030" required>
        </div>
        

        <input type="hidden" name="token" value="eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1c2VyX2lkIjoyNDUwOSwidXNlcm5hbWUiOiJzcXVhZG1nckBjZWxsbWluaXN0cnkudHYiLCJleHAiOjE3NDk4Mzk3NTR9.2Sasd9717JNS6pulIPA8EiHe7QgXClusMKX_tCgefP0">

        

        <div class="form-group">
            <label for="position_in_church">Position in Church</label>
            <select class="form-control" id="position_in_church" name="position_in_church" required>
                <option value="">Select a position</option>
                <option value="Pastoral Assistant">Pastoral Assistant</option>
                <option value="Deaconry member">Deaconry member</option>
                <option value="Group Pastor">Group Pastor</option>
                <option value="Church Pastor">Church Pastor</option>
                <option value="PCF leader">PCF leader</option>
                <option value="PCU leader">PCU leader</option>
                <option value="Senior Cell leader">Senior Cell leader</option>
                <option value="Cell leader">Cell leader</option>
                <option value="Service centre coordinator">Service centre coordinator</option>
                <option value="Outreach fellowship">Outreach fellowship</option>
                <option value="Prison ministry chaplain/coordinator">Prison ministry chaplain/coordinator</option>
                <option value="Member">Member</option>
                <option value="Foundation school teacher">Foundation school teacher</option>
                <option value="Service department leader">Service department leader</option>
                <option value="Others">Others</option>
            </select>
        </div>

        <button type="submit" class="btn btn-primary">Register</button>
    </form>
    </div>

       <script>
        function showRegistrationStatus(status, message) {
            var registrationStatus = $('#registration-status');
            registrationStatus.removeClass('alert-success alert-danger');
            registrationStatus.addClass('alert-' + status);
            registrationStatus.text(message);
            registrationStatus.show();
        }

        $('#registration-form').on('submit', function(e) {
            e.preventDefault();

            var formData = $(this).serializeArray();
            var jsonData = {};

            $.map(formData, function(n, i) {
                jsonData[n.name] = n.value;
            });

            var apiUrl = 'registerX.php';

            $.ajax({
                type: 'POST',
                url: apiUrl,
                data: JSON.stringify(jsonData),
                contentType: 'application/json',
                success: function(response, status, xhr) {
                    if (xhr.status === 201) {
                        $('#registration-form').hide(); // Hide the form
                        $('#success-message').show(); // Show success message
                    } else {
                        // Handle unexpected response
                        if (response.message === "Registration successful.") {
                            $('#registration-form').hide(); // Hide the form
                            $('#success-message').show(); // Show success message
                        } else {
                            showRegistrationStatus('danger', 'Unexpected response format.');
                            $('#registration-status').show();
                        }
                    }
                },
                error: function(xhr, status, error) {
                    // Handle registration errors
                    console.error(xhr, status, error);
                    var errorMessage = xhr.responseJSON && xhr.responseJSON.error ? xhr.responseJSON.error : 'Registration failed.';
                    showRegistrationStatus('danger', errorMessage);
                    $('#registration-status').show();
                }
            });
        });
    </script>
</body>
</html>