<?php
// api/registerX.php
require_once '../../database.php';
require_once '../../auth.php';
//require_once '../config.php';

//testing request logging
// Get the raw POST data
$postData = file_get_contents('php://input');

// Define the log file path
$logFile = 'file.txt';

// Append the POST data to the log file
file_put_contents($logFile, $postData . PHP_EOL, FILE_APPEND | LOCK_EX);

// Optionally, you can also add a timestamp to each entry
// $timestamp = date('Y-m-d H:i:s');
// file_put_contents($logFile, $timestamp . ' - ' . $postData . PHP_EOL, FILE_APPEND | LOCK_EX);

//end testing request logging
/**
//var_dump($_SERVER['HTTP_AUTHORIZATION']);

//var_dump($_SERVER);

// Verify the JWT token
$token = $_SERVER['HTTP_AUTHORIZATION'];
$user = verifyToken($token);

if (!$user) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid token.']);
    exit;
}


// Print the headers
print_r(getallheaders());

// Get the request payload
$requestPayload = json_decode(file_get_contents('php://input'), true);
**/

// Verify the JWT token
$requestPayload = json_decode(file_get_contents('php://input'), true);
$token = $requestPayload['token'];
$user = verifyToken($token);

if (!$user) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid token.']);
    exit;
}

// Print the headers
//print_r(getallheaders());
// Extract the registration data
$title = $requestPayload['title'];
$first_name = $requestPayload['first_name'];
$last_name = $requestPayload['last_name'];
$zone = $requestPayload['zone'];
$church = $requestPayload['church'];
$kingschat_number = $requestPayload['kingschat_number'];
$email = $requestPayload['email'];
$phone_number = $requestPayload['phone_number'];
$year_joined_church = $requestPayload['year_joined_church'];
$water_baptized = $requestPayload['water_baptized'];
$year_graduated_foundation = $requestPayload['year_graduated_foundation'];
$position_in_church = $requestPayload['position_in_church'];

// Validate and sanitize the data
if (
    empty($title) || empty($first_name) || empty($last_name) || empty($zone) || empty($church) || empty($kingschat_number) ||
    empty($email) || empty($phone_number) || empty($year_joined_church) || empty($water_baptized) || empty($year_graduated_foundation) ||
    empty($position_in_church)
) {
    http_response_code(400);
    echo json_encode(['error' => 'All fields are required.']);
    exit;
}

$title = filter_var($title, FILTER_SANITIZE_STRING);
$first_name = filter_var($first_name, FILTER_SANITIZE_STRING);
$last_name = filter_var($last_name, FILTER_SANITIZE_STRING);
$zone = filter_var($zone, FILTER_SANITIZE_STRING);
$church = filter_var($church, FILTER_SANITIZE_STRING);
$kingschat_number = filter_var($kingschat_number, FILTER_SANITIZE_STRING);
$email = filter_var($email, FILTER_SANITIZE_EMAIL);
$phone_number = filter_var($phone_number, FILTER_SANITIZE_STRING);
$year_joined_church = filter_var($year_joined_church, FILTER_SANITIZE_NUMBER_INT);
$water_baptized = filter_var($water_baptized, FILTER_SANITIZE_STRING);
$year_graduated_foundation = filter_var($year_graduated_foundation, FILTER_SANITIZE_NUMBER_INT);
$position_in_church = filter_var($position_in_church, FILTER_SANITIZE_STRING);

// Store the registration data in the database
$stmt = $pdo->prepare("INSERT INTO squadpeople (title, first_name, last_name, zone, church, kingschat_number, email, phone_number, year_joined_church, water_baptized, year_graduated_foundation, position_in_church) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->execute([$title, $first_name, $last_name, $zone, $church, $kingschat_number, $email, $phone_number, $year_joined_church, $water_baptized, $year_graduated_foundation, $position_in_church]);

if ($stmt->rowCount() > 0) {
    // Registration successful
    http_response_code(201);
    echo json_encode(['message' => 'Registration successful.']);
} else {
    // Registration failed
    http_response_code(500);
    echo json_encode(['error' => 'Registration failed.']);
}?>