<?php
error_reporting(E_ALL);
// Assuming you have already established a database connection and retrieved nominee data
// Modify the following code accordingly

// Retrieve nominee data (you can replace this with your actual database query)
// Example data (replace with actual data from your database)
$row = [
    'nominee_id' => 123,
    'nominee_name' => 'John Doe',
    'zone_ministry_centre' => 'Example Zone',
    'nominee_code' => 'ABC123',
    'title' => 'Certificate of Achievement',
];

// Read the HTML template from certhtml.php
$html = file_get_contents('certhtml.php');

// Replace placeholders with actual data
$html = str_replace('[[nomineename]]', $row['nominee_name'], $html);
$html = str_replace('[[day]]', date('d'), $html); // Example: current day
$html = str_replace('[[month]]', date('F'), $html); // Example: current month
$html = str_replace('[[year]]', date('Y'), $html); // Example: current year
$html = str_replace('[[church_zone]]', $row['zone_ministry_centre'], $html);
$html = str_replace('[[nomineeid]]', $row['nominee_id'], $html);

// Create a new PDF document (using TCPDF or any other library)
// Example: using TCPDF
require_once '../tcpdf/tcpdf.php';
$pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8');
$pdf->SetCreator('Your Organization');
$pdf->SetAuthor('Your Organization');
$pdf->SetTitle('Certificate');
$pdf->SetSubject('Certificate for ' . $row['nominee_name']);
$pdf->AddPage();
$pdf->writeHTML($html, true, false, true, false, '');

// Save the PDF file with a unique filename
$userDir = 'certificates/' . $loggedInUserId . '/' . $selectedBatchId;
if (!is_dir($userDir)) {
    mkdir($userDir, 0755, true);
}
$filename = $userDir . '/certificate_' . $row['nominee_id'] . '.pdf';
$pdf->Output($filename, 'F');

// Display success message
echo '<p>Certificate generated for ' . $row['nominee_name'] . ': <a href="' . $filename . '">Download</a></p>';
?>
