<?php
error_reporting(E_ALL);

// Increase execution time limit for PDF generation
set_time_limit(30000); // 5 minutes
ini_set('memory_limit', '5120M'); // Increase memory limit

require_once '../config.php';
require_once 'tcpdf/tcpdf.php';

//var_dump($_POST);
// Establish the database connection
$connection = mysqli_connect($db_host, $db_user, $db_password, $db_name);
if (!$connection) {
    die("Connection failed: " . mysqli_connect_error());
}

// Get the selected batch ID from the POST variables
$selectedBatchId = $_POST['batch_id']; // Assuming you retrieve the selected batch ID from a form submission

// Get the logged-in user ID from the session
session_start();

// Check if the user is logged in as a system admin
if (!isset($_SESSION['userType']) || $_SESSION['userType'] !== 'member') {
    header('Location: ../indexX.php');
    exit;
}

$loggedInUserId = $_SESSION['id']; // Assuming you have stored the user ID in a session variable
//echo $loggedInUserId;
// Prepare the SQL query with the batch ID and user ID conditions
$query = "SELECT nominee_id, nominee_name, zone_ministry_centre,nominee_code, title FROM NomineeData WHERE batchid = '$selectedBatchId' AND user_id = '$loggedInUserId'";
$result = mysqli_query($connection, $query);

if (!$result) {
    die("Error retrieving data from the database: " . mysqli_error($connection));
}

// Generate certificates
while ($row = mysqli_fetch_assoc($result)) {
    //echo $row['nominee_name'];
    // Create a new PDF document
    $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8');

    // Set document information and meta tags
    $pdf->SetCreator('Your Organization');
    $pdf->SetAuthor('Your Organization');
    $pdf->SetTitle('Certificate');
    $pdf->SetSubject('Certificate for ' . $row['nominee_name']);

    // Add a page to the PDF
    $pdf->AddPage();

    // Customize the certificate layout using HTML and CSS
    $html = '
        <style>
            /* Add your CSS styles here */
        </style>
        <h1>Certificate of Achievement</h1>
        <p>This is to certify that ' . $row['nominee_name'] . ' has been nominated from ' . $row['zone_ministry_centre'] . '.</p>
        <!-- Add more HTML content specific to the certificate -->
    ';

    // Write the HTML content to the PDF
    $pdf->writeHTML($html, true, false, true, false, '');

    // Create a directory for the user if it doesn't exist
    $userDir = 'certificates/' . $loggedInUserId . '/' . $selectedBatchId;
    //echo $userDir;
    if (!is_dir($userDir)) {
        mkdir($userDir, 0755, true);
    }

    // Save the PDF file
    $filename = $userDir . '/certificate_' . $row['nominee_id'] . '.pdf';
    $pdf->Output($filename, 'F');

    if($pdf->Error){
  echo 'Error creating TCPDF object: ' . $pdf->Error;
  exit;
}

    // Clear the PDF object to generate the next certificate
    unset($pdf);
}

// Close the database connection
mysqli_close($connection);

include('../headerspecial.php');

echo '<h2>Certificate generation complete!</h2>';
echo '<p><a href="INDUCTION_CERTIFICATE_LOWER_QUALITY.png-2 (1).jpg.zip">Please click here to download the certificates in this batch</a>.'
//echo '<p><a href="download_certificates.php?bid='.$selectedBatchId.'">Please click here to download the certificates in this batch</a>.'
?>
