<?php
error_reporting(E_ALL);

// Increase execution time limit for PDF generation
set_time_limit(30000); // 5 minutes
ini_set('memory_limit', '5120M'); // Increase memory limit

require_once '../config.php';
require_once 'tcpdf/tcpdf.php';

//var_dump($_POST);
// Establish the database connection
$connection = mysqli_connect($db_host, $db_user, $db_password, $db_name);
if (!$connection) {
    die("Connection failed: " . mysqli_connect_error());
}

// Get the selected batch ID from the POST variables
$selectedBatchId = $_POST['batch_id']; // Assuming you retrieve the selected batch ID from a form submission

// Get the logged-in user ID from the session
session_start();
//echo $_SESSION['id'];
// Check if the user is logged in as a system admin
if (!isset($_SESSION['userType']) || $_SESSION['userType'] !== 'member') {
    header('Location: ../indexX.php');
    exit;
}

$loggedInUserId = $_SESSION['id']; // Assuming you have stored the user ID in a session variable
//echo $loggedInUserId;
// Prepare the SQL query with the batch ID and user ID conditions
$query = "SELECT nominee_id, nominee_name, zone_ministry_centre,nominee_code, title FROM NomineeData WHERE batchid = '$selectedBatchId' AND user_id = '$loggedInUserId'";
$result = mysqli_query($connection, $query);

if (!$result) {
    die("Error retrieving data from the database: " . mysqli_error($connection));
}

// Generate certificates
while ($row = mysqli_fetch_assoc($result)) {
    //echo $row['nominee_name'];
    // Create a new PDF document
    $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8');

    // Set document information and meta tags
    $pdf->SetCreator('Your Organization');
    $pdf->SetAuthor('Your Organization');
    $pdf->SetTitle('Certificate');
    $pdf->SetSubject('Certificate for ' . $row['nominee_name']);

    // Add a page to the PDF
    $pdf->AddPage();

    // Customize the certificate layout using HTML and CSS
    //date magic
    $dateString = '2024-10-02';
    $date = new DateTime($dateString);
    $formattedDate = $date->format('jS \Day of F Y');

    // Separate the components
    $day = substr($formattedDate, 0, 2);
    $month = substr($formattedDate, 9, -8);
    $year = substr($formattedDate, -4);
    $shortYear = substr($formattedDate, -2);

    $html = '
          <style>
          </style>
          <h1>Certificate of Achievement</h1>
          <p>This is to certify that ' . $row['nominee_name'] . ' has been nominated from ' . $row['zone_ministry_centre'] . '.</p>
          <!-- Add more HTML content specific to the certificate -->
          <div><p>

    <img src="images/Aspose.Words.55d7a472-7791-4c47-9f64-1c66b7bd5cf5.004.png" width="128" height="128" alt="loveworld" style="-aw-left-pos:0pt; -aw-rel-hpos:column; -aw-rel-vpos:paragraph; -aw-top-pos:0pt; -aw-wrap-type:inline" /><img src="images/Aspose.Words.55d7a472-7791-4c47-9f64-1c66b7bd5cf5.005.png" width="553" height="85" alt="subject" style="-aw-left-pos:0pt; -aw-rel-hpos:column; -aw-rel-vpos:paragraph; -aw-top-pos:0pt; -aw-wrap-type:inline" />


             <table cellspacing="0" cellpadding="0" class="TableGrid" style="width:462.45pt; margin-right:9pt; margin-left:66pt; border-collapse:collapse; float:left; text-align:center;   margin-top: 75px;">
               <tr>
                 <td><img src ="images\Aspose.Words.55d7a472-7791-4c47-9f64-1c66b7bd5cf5.004.png"><p><img src="images\Aspose.Words.55d7a472-7791-4c47-9f64-1c66b7bd5cf5.005.png">
                 <p>
                  </td></tr>
                <tr>
                   <td style="width:451.65pt; padding-right:5.4pt; padding-left:5.4pt; vertical-align:top">
                      <p style="text-align:center; widows:0; orphans:0; font-size:5.5pt"><span style="font-family:Papyrus; -aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:22pt"><span style="font-family:Papyrus; font-style:italic; color:#0022c4">This Certifies That</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="font-family:Papyrus; -aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:26pt"><span style="font-family:Papyrus; font-weight:bold; text-decoration:underline; color:#ffc000">' . $row['nominee_name'] . '</span></p>
                   </td>
                </tr>
                <tr>
                   <td style="width:451.65pt; padding-right:5.4pt; padding-left:5.4pt; vertical-align:top">
                      <p style="text-align:center; widows:0; orphans:0; font-size:16pt"><span style="font-weight:bold; color:#0022c5; -aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:16pt"><span style="font-weight:bold; color:#0022c5">Has demonstrated exemplary leadership qualities,</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:16pt"><span style="font-weight:bold; color:#0022c5; -aw-import:spaces">&#xa0;</span><span style="font-weight:bold; color:#0022c5">dedication, and commitment to the Vision of the ministry</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:16pt"><span style="font-weight:bold; color:#0022c5; -aw-import:spaces">&#xa0; </span><span style="font-weight:bold; color:#0022c5">(Loveworld a.k.a Christ Embassy).</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:16pt"><span style="font-weight:bold; color:#0022c5; -aw-import:spaces">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:16pt"><span style="font-weight:bold; color:#0022c5">This certificate is a symbol of his/her induction into the</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:16pt"><span style="font-weight:bold; color:#0022c5; -aw-import:spaces">&#xa0; </span><span style="font-weight:bold; color:#0022c5">leadership role of a cell leader. </span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:16pt"><span style="font-weight:bold; color:#0022c5; -aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="color:#0022c5; -aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="color:#0022c5; -aw-import:ignore">&#xa0;</span></p>
                   </td>
                </tr>
                <tr>
                   <td style="width:451.65pt; padding-right:5.4pt; padding-left:5.4pt; vertical-align:top">
                      <p style="text-align:center; widows:0; orphans:0; font-size:16pt"><span style="font-weight:bold; color:#0022c5">This certificate was issued ' . $day . ' day of ' . $month . ' 20' . $shortYear . '</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:16pt"><span style="font-weight:bold; color:#0022c5; -aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:16pt"><span style="font-weight:bold; color:#0022c5">at ' . $row['zone_ministry_centre'] . '</span><span style="font-weight:bold; color:#0022c5; -aw-import:spaces">&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0; </span> </p>
                   </td>
                </tr>
                <tr>
                   <td style="width:451.65pt; padding-right:5.4pt; padding-left:5.4pt; vertical-align:top">
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="-aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="-aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="-aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="-aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="-aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="-aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="-aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="-aw-import:ignore">&#xa0;</span></p>
                   </td>
                </tr>
                <tr>
                   <td style="width:451.65pt; padding-right:5.4pt; padding-left:5.4pt; vertical-align:top">
                      <div style="text-align:center">
                         <table cellspacing="0" cellpadding="0" class="TableGrid" style="margin-right:auto; margin-left:auto; border-collapse:collapse">
                            <tr>
                               <td style="width:127.6pt; padding-right:5.4pt; padding-left:5.4pt; vertical-align:middle">
                                  <p style="widows:0; orphans:0; font-size:14pt"><span style="font-weight:bold; color:#0022c5">' . $row['nominee_code'] . '</span></p>
                               </td>
                               <td style="width:127.65pt; padding-right:5.4pt; padding-left:5.4pt; vertical-align:top">
                                  <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><img src="images/Aspose.Words.55d7a472-7791-4c47-9f64-1c66b7bd5cf5.001.png" width="127" height="60" alt="cellministry" style="-aw-left-pos:0pt; -aw-rel-hpos:column; -aw-rel-vpos:paragraph; -aw-top-pos:0pt; -aw-wrap-type:inline" /></p>
                               </td>
                               <td style="width:127.65pt; padding-right:5.4pt; padding-left:5.4pt; vertical-align:top">
                                  <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><img src="images/Aspose.Words.55d7a472-7791-4c47-9f64-1c66b7bd5cf5.002.png" width="153" height="38" alt="director" style="-aw-left-pos:0pt; -aw-rel-hpos:column; -aw-rel-vpos:paragraph; -aw-top-pos:0pt; -aw-wrap-type:inline" /><br /><span style="font-weight:bold; color:#0022c5">The Director,</span><span style="font-weight:bold; color:#0022c5; -aw-import:spaces">&#xa0;&#xa0;&#xa0; </span></p>
                                  <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="font-weight:bold; color:#0022c5">Loveworld Cell Ministry</span><span style="font-weight:bold"> </span></p>
                               </td>
                            </tr>
                         </table>
                      </div>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"></p>
                   </td>
                </tr>
                <tr>
                   <td style="width:451.65pt; padding-right:5.4pt; padding-left:5.4pt; vertical-align:top">
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="-aw-import:ignore">&#xa0;</span></p>
                   </td>
                </tr>
                <tr>
                   <td style="width:451.65pt; padding-right:5.4pt; padding-left:5.4pt; vertical-align:top">
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="font-style:italic; -aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:justify; widows:0; orphans:0; font-size:10pt"><span style="font-style:italic; -aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:10pt"><span style="font-style:italic; -aw-import:ignore">&#xa0;</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:11pt"><span style="font-style:italic">“It is more honourable to be a cell leader than to be the President of a nation”</span></p>
                      <p style="text-align:center; widows:0; orphans:0; font-size:11pt"><span style="font-style:italic; color:#ed7d31">.....Rev. Dr. Chris Oyakhilome</span><span style="font-size:10pt; font-style:italic; color:#ed7d31"> </span></p>
                   </td>
                </tr>
             </table>
             <p style="text-align:center"><span style="height:0pt; text-align:left; display:block; position:absolute; z-index:-1"><img src="images/Aspose.Words.55d7a472-7791-4c47-9f64-1c66b7bd5cf5.003.png" width="808" height="1143" alt="cert_bg" style="margin-top:0; margin-left:0; -aw-left-pos:-91.95pt; -aw-rel-hpos:column; -aw-rel-vpos:paragraph; -aw-top-pos:-62.05pt; -aw-wrap-type:none; position:absolute" /></span></p>
             <p style="text-align:center"><span style="-aw-import:ignore">&#xa0;</span></p>
          </div>
      ';
    echo $html;

    // Write the HTML content to the PDF
    $pdf->writeHTML($html, true, false, true, false, '');

    // Create a directory for the user if it doesn't exist
    $userDir = 'certificates/' . $loggedInUserId . '/' . $selectedBatchId;
    //echo $userDir;
    if (!is_dir($userDir)) {
        mkdir($userDir, 0755, true);
    }

    // Save the PDF file
    $filename = $userDir . '/certificate_' . $row['nominee_id'] . '.pdf';
    $pdf->Output($filename, 'F');

    if($pdf->Error){
  echo 'Error creating TCPDF object: ' . $pdf->Error;
  exit;
}

    // Clear the PDF object to generate the next certificate
    unset($pdf);
}

// Close the database connection
mysqli_close($connection);

include('../headerspecial.php');

echo '<h2>Certificate generation complete!</h2>';
echo '<p><a href="INDUCTION_CERTIFICATE_LOWER_QUALITY.png-2 (1).jpg.zip">Please click here to download the certificates in this batch</a>.'
//echo '<p><a href="download_certificates.php?bid='.$selectedBatchId.'">Please click here to download the certificates in this batch</a>.'
?>
