<?php
require_once '../config.php';

// Establish the database connection
$connection = mysqli_connect($db_host, $db_user, $db_password, $db_name);
if (!$connection) {
    die("Connection failed: " . mysqli_connect_error());
}

// Get the logged-in user ID from the session
session_start();
// Check if the user is logged in as a system admin
if (!isset($_SESSION['userType']) || $_SESSION['userType'] !== 'member') {
    header('Location: ../indexX.php');
    exit;
}

$loggedInUserId = $_SESSION['id']; // Assuming you have stored the user ID in a session variable

// Retrieve the current user's batches
$query = "SELECT batchid, count(*) as batch_count, any_value(inductionDate) as inductionDate  FROM NomineeData WHERE user_id = '$loggedInUserId' group by batchid order by batchid desc";
$result = mysqli_query($connection, $query);

if (!$result) {
    die("Error retrieving data from the database: " . mysqli_error($connection));
}

// Display the list of batches
include('../headerspecial.php');
echo '<h1>My Nominee Records (Batches)</h1><p>Please click the corresponding button to generate certificates for the desired batch.<p>';
echo '<table class="datatable" >';
echo '<thead><tr><th>Batch Date</th><th>Batch ID</th><th>Batch Count</th><th>Induction Date</th><th>Action</th></tr>';

while ($row = mysqli_fetch_assoc($result)) {
    $batchId = $row['batchid'];
    $batchCount = $row['batch_count'];
	$inductionDate = $row['inductionDate'];
      $timestamp = $batchId;
      $formattedDate = substr($timestamp, 0, 4) . "-" . substr($timestamp, 4, 2) . "-" . substr($timestamp, 6, 2);
      $formattedTime = substr($timestamp, 8, 2) . ":" . substr($timestamp, 10, 2) . ":" . substr($timestamp, 12, 2);

      $formattedDateTime = $formattedDate . " " . $formattedTime;

      //echo $formattedDateTime;

    // Display each batch in a table row with a button
    echo ' </thead>
            <tbody><tr>';
    echo '<td>' . $formattedDateTime . '</td>';
    echo '<td>' . $batchId . '</td>';
    echo '<td>' . $batchCount . '</td>';
	 echo '<td>' . $inductionDate . '</td>';

   echo '<td><form action="generate_cert_batchLIVE.php" method="post">
              <input type="hidden" name="batch_id" value="' . $batchId . '">
              <input type="submit" value="Generate Certificates">
          </form></td>';
	/**  echo '<td><form action="#" method="post">
              <input type="hidden" name="batch_id" value="#">
              <input type="submit" value="Generate Certificates">
          </form></td>';	 **/ 
    echo '</tr>';
}

echo '</table>';

// Close the database connection
mysqli_close($connection);
?>

	<script>
$(document).ready(function() {
  $('.datatable').DataTable({
  "paging": true,
  "searching": true
});
});
</script>

<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.12.1/css/jquery.dataTables.css">

<script type="text/javascript" src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.js"></script>
