<?php
// Assuming you have established a database connection
// Include necessary files and start session
require_once '../config.php';
session_start();
//var_dump($_SESSION);
// Check if the user is logged in as a system admin
if (!isset($_SESSION['userType']) || $_SESSION['userType'] !== 'member') {
    header('Location: ../indexX.php');
    exit;
}

// Fetch the zone_ministry_centre from the users table
$userId = $_SESSION['id']; // Assuming you have stored the user ID in the session

try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_password);

    // Set PDO error mode to exception
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Prepare and execute the query to retrieve the zone
    $query = "SELECT zone FROM users WHERE id = :userId";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
    $stmt->execute();

    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $zoneMinistryCentre = $row['zone'];
} catch (PDOException $e) {
    // Handle database error
    $zoneMinistryCentre = ""; // Set the default value to an empty string
    echo "Error: " . $e->getMessage();
}

try {
    // Prepare and execute the query to retrieve the nominee records
    $selectQuery = "SELECT * FROM NomineeData WHERE user_id = :userId";
    $stmt = $pdo->prepare($selectQuery);
    $stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
    $stmt->execute();

    $nomineesResult = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    // Handle database error or no rows found
    $nomineesResult = array(); // Set an empty array
    echo "Error: " . $e->getMessage();
}

include('../headerspecial.php');
?>

<!DOCTYPE html>
<html>
<head>
    <title>Nominees Directory</title>
    <!-- Add any necessary CSS or JavaScript files -->
</head>
<body>
    <h1>Nominees Directory</h1>
    <p>
      <a href ="mybatches.php">Generate certificates.</a>

    <?php
    // Display the nominee records if available
    if (count($nomineesResult) > 0) {
        echo '<table class="datatable"  >';
        echo '<thead><tr><th>Title</th><th>Nominee Name</th><th>Group Name</th><th>Church Name</th><th>Date_Joined_Ministry</th><th>Date_Water_Baptized</th><th>Date_Graduated_Foundation</th><th>Nominee_Training</th><th>Nominee_Code</th><th>Batch ID</th></tr>';

        foreach ($nomineesResult as $row) {
            echo ' </thead>
            <tbody><tr>';
            echo '<td>' . $row['title'] . '</td>';
            echo '<td>' . $row['nominee_name'] . '</td>';
            echo '<td>' . $row['group_name'] . '</td>';
            echo '<td>' . $row['church_name'] . '</td>';
            echo '<td>' . $row['date_joined_ministry'] . '</td>';
            echo '<td>' . $row['date_water_baptized'] . '</td>';
            echo '<td>' . $row['date_graduated_foundation'] . '</td>';
            echo '<td>' . $row['has_cell_nominee_training'] . '</td>';
            echo '<td>' . $row['nominee_code'] . '</td>';
            echo '<td>' . $row['batchid'] . '</td>';
            echo '</tr></tbody>';
        }

        echo '</table>';
    } else {
        echo '<p>No nominees found.</p>';
    }
    ?>

    <!-- Add any additional HTML or PHP code as needed -->
		
	<script>
$(document).ready(function() {
  $('.datatable').DataTable({
  "paging": true,
  "searching": true
});
});
</script>

<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.12.1/css/jquery.dataTables.css">

<script type="text/javascript" src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.js"></script>

</body>
</html>
