<?php
require_once '../config.php';
session_start();
//var_dump($_SESSION);

if (!isset($_SESSION['userType']) || $_SESSION['userType'] !== 'member') {
    header('Location: ../indexX.php');
    exit;
}

$connection = mysqli_connect($db_host, $db_user, $db_password, $db_name);

if (!$connection) {
    die("Connection failed: " . mysqli_connect_error());
}

$userId = $_SESSION['id'];
$query = "SELECT zone, credits FROM users WHERE id = ?";
$stmt = mysqli_prepare($connection, $query);
mysqli_stmt_bind_param($stmt, "i", $userId);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if ($result) {
    $row = mysqli_fetch_assoc($result);
    $zoneMinistryCentre = $row['zone'];
    $credit = $row['credits'];
} else {
    $zoneMinistryCentre = "";
    $credit = 0;
}

function sanitizeInput($input) {
    $sanitizedInput = trim($input);
    $sanitizedInput = stripslashes($sanitizedInput);
    $sanitizedInput = htmlspecialchars($sanitizedInput);
    return $sanitizedInput;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($credit > 1) {
        $title = sanitizeInput($_POST['title']);
        $nomineeName = sanitizeInput($_POST['nominee_name']);
        $groupName = sanitizeInput($_POST['group_name']);
        $churchName = sanitizeInput($_POST['church_name']);
        $dateJoinedMinistry = sanitizeInput($_POST['date_joined_ministry']);
        $dateWaterBaptized = sanitizeInput($_POST['date_water_baptized']);
        $dateGraduatedFoundation = sanitizeInput($_POST['date_graduated_foundation']);
        $hasCellNomineeTraining = isset($_POST['has_cell_nominee_training']) ? 1 : 0;
        $nomineeCode = sanitizeInput($_POST['nominee_code']);

        $insertQuery = "INSERT INTO NomineeData (title, nominee_name, zone_ministry_centre, group_name, church_name, date_joined_ministry, date_water_baptized, date_graduated_foundation, has_cell_nominee_training, nominee_code, user_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = mysqli_prepare($connection, $insertQuery);
        mysqli_stmt_bind_param($stmt, "ssssssssisi", $title, $nomineeName, $zoneMinistryCentre, $groupName, $churchName, $dateJoinedMinistry, $dateWaterBaptized, $dateGraduatedFoundation, $hasCellNomineeTraining, $nomineeCode, $userId);
        $insertResult = mysqli_stmt_execute($stmt);

        if ($insertResult) {
            $user_id = $userId;
            $credits = 1;

            $updateQuery = "UPDATE users SET credits = credits - ? WHERE id = ?";
            $stmt = mysqli_prepare($connection, $updateQuery);
            mysqli_stmt_bind_param($stmt, "ii", $credits, $user_id);
            $updateResult = mysqli_stmt_execute($stmt);

            if ($updateResult) {
                header('Location: nominees2.php');
                exit;
            } else {
                echo "Error: " . mysqli_error($connection);
            }
        } else {
            echo "Error: " . mysqli_error($connection);
        }
    } else {
        header('Location: single_upload.php?error=credit');
        exit;
    }
}

mysqli_close($connection);
include('../headerspecial.php');
?>

<!-- HTML Markup for the Single Upload Form -->

<!DOCTYPE html>
<html>
<head>
    <title>Single Upload - Nominee Information</title>
</head>
<body>
    <h1>Single Upload - Nominee Information</h1>

    <!-- Display error message if credit is not greater than 1 -->
    <?php
    if (isset($_GET['error']) && $_GET['error'] === 'credit') {
        echo '<p>Error: Insufficient credit. Please ensure your credit is greater than 1.</p>';
    }
    ?>
    <!-- Nominee Information Form -->
    <form method="POST" action="single_upload.php">
        <!-- Form fields -->
        <label for="title">Title:</label>
        <input type="text" name="title" id="title" required><p>

        <label for="nominee_name">Nominee Name:</label>
        <input type="text" name="nominee_name" id="nominee_name" required><p>

        <label for="zone_ministry_centre">Zone Ministry Centre:</label>
        <input type="text" name="zone_ministry_centre" id="zone_ministry_centre" value="<?php echo $zoneMinistryCentre; ?>" readonly><p>

        <label for="group_name">Group Name:</label>
        <input type="text" name="group_name" id="group_name" required><p>

        <label for="church_name">Church Name:</label>
        <input type="text" name="church_name" id="church_name" required><p>

        <label for="date_joined_ministry">Date Joined Ministry:</label>
        <input type="date" name="date_joined_ministry" id="date_joined_ministry" required><p>

        <label for="date_water_baptized">Date Water Baptized:</label>
        <input type="date" name="date_water_baptized" id="date_water_baptized" required><p>

        <label for="date_graduated_foundation">Date Graduated Foundation:</label>
        <input type="date" name="date_graduated_foundation" id="date_graduated_foundation" required><p>

        <label for="has_cell_nominee_training">Has Cell Nominee Training:</label>
        <input type="checkbox" name="has_cell_nominee_training" id="has_cell_nominee_training"><p>

        <label for="nominee_code">Nominee Code:</label>
        <input type="text" name="nominee_code" id="nominee_code" required><p>

        <button type="submit">Upload</button>
    </form>
</body>
</html>
