<?php
// Assuming you have established a database connection
// Include necessary files and start session
require_once '../config.php';
session_start();
//var_dump($_SESSION);

// Check if the user is logged in as a system admin
$connection = mysqli_connect($db_host, $db_user, $db_password, $db_name);

if (!isset($_SESSION['userType']) || $_SESSION['userType'] !== 'member') {
    header('Location: ../indexX.php');
    exit;
}

// Fetch the zone_ministry_centre from the users table
$userId = $_SESSION['id']; // Assuming you have stored the user ID in the session
$query = "SELECT zone, credits FROM users WHERE id = $userId";
$result = mysqli_query($connection, $query);

if ($result) {
    $row = mysqli_fetch_assoc($result);
    $zoneMinistryCentre = $row['zone'];
    $credit = $row['credits'];
//    echo 'my credits - '.$credit;

} else {
    // Handle database error
    $zoneMinistryCentre = ""; // Set the default value to an empty string
    $credit = 0; // Set the default credit to 0
}

// Process the form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if the credit is greater than 1
    if ($credit > 1) {
        // Retrieve the form data
        $title = $_POST['title'];
        $nomineeName = $_POST['nominee_name'];
        $groupName = $_POST['group_name'];
        $churchName = $_POST['church_name'];
        $dateJoinedMinistry = $_POST['date_joined_ministry'];
        $dateWaterBaptized = $_POST['date_water_baptized'];
        $dateGraduatedFoundation = $_POST['date_graduated_foundation'];
        $hasCellNomineeTraining = isset($_POST['has_cell_nominee_training']) ? 1 : 0;
        $nomineeCode = $_POST['nominee_code'];

        // Perform the necessary actions with the form data
        // For example, you can insert the data into the database
        $insertQuery = "INSERT INTO NomineeData (title, nominee_name, zone_ministry_centre, group_name, church_name, date_joined_ministry, date_water_baptized, date_graduated_foundation, has_cell_nominee_training, nominee_code, user_id) VALUES ('$title', '$nomineeName', '$zoneMinistryCentre', '$groupName', '$churchName', '$dateJoinedMinistry', '$dateWaterBaptized', '$dateGraduatedFoundation', '$hasCellNomineeTraining', '$nomineeCode', '$userId')";

        // Execute the insert query
        $insertResult = mysqli_query($connection, $insertQuery);

        if ($insertResult) {
            // Insertion successful
            // Deduct credit from user credit
            $user_id = $userId;
            $credits = 1;

            // Update the credits for the specified user in the users table
            $updateQuery = "UPDATE users SET credits = credits - $credits WHERE id = $user_id";
            $updateResult = mysqli_query($connection, $updateQuery);

            if ($updateResult) {
                // Credit deduction successful
                // Redirect or display success message
                header('Location: nominees2.php');
                exit;
            } else {
                // Credit deduction failed
                // Handle the error
                // Example: echo "Error: " . mysqli_error($connection);
            }
        } else {
            // Insertion failed
            // Handle the error
            // Example: echo "Error: " . mysqli_error($connection);
        }
    } else {
        // Credit is not greater than 1
        // Handle the error
        // For example, you can redirect back to the form with an error message
        header('Location: single_upload1.php?error=credit');
        exit;
    }
}

// Close the database connection
mysqli_close($connection);
include('../headerspecial.php');
?>

<!-- HTML Markup for the Single Upload Form -->
<!DOCTYPE html>
<html>
<head>
    <title>Single Upload - Nominee Information</title>
</head>
<body>
    <h1>Single Upload - Nominee Information</h1>

    <!-- Display error message if credit is not greater than 1 -->
    <?php
    if (isset($_GET['error']) && $_GET['error'] === 'credit') {
        echo '<p>Error: Insufficient credit. Please ensure your credit is greater than 1.</p>';
    }
    ?>
    <!-- Nominee Information Form -->
    <form method="POST" action="single_upload1.php">
        <!-- Form fields -->
        <label for="title">Title:</label>
        <input type="text" name="title" id="title" required><p>

        <label for="nominee_name">Nominee Name:</label>
        <input type="text" name="nominee_name" id="nominee_name" required><p>

        <label for="zone_ministry_centre">Zone Ministry Centre:</label>
        <input type="text" name="zone_ministry_centre" id="zone_ministry_centre" value="<?php echo $zoneMinistryCentre; ?>" readonly><p>

        <label for="group_name">Group Name:</label>
        <input type="text" name="group_name" id="group_name" required><p>

        <label for="church_name">Church Name:</label>
        <input type="text" name="church_name" id="church_name" required><p>

        <label for="date_joined_ministry">Date Joined Ministry:</label>
        <input type="date" name="date_joined_ministry" id="date_joined_ministry" required><p>

        <label for="date_water_baptized">Date Water Baptized:</label>
        <input type="date" name="date_water_baptized" id="date_water_baptized" required><p>

        <label for="date_graduated_foundation">Date Graduated Foundation:</label>
        <input type="date" name="date_graduated_foundation" id="date_graduated_foundation" required><p>

        <label for="has_cell_nominee_training">Has Cell Nominee Training:</label>
        <input type="checkbox" name="has_cell_nominee_training" id="has_cell_nominee_training"><p>

        <label for="nominee_code">Nominee Code:</label>
        <input type="text" name="nominee_code" id="nominee_code" required><p>

        <button type="submit">Upload</button>
    </form>
</body>
</html>
